package furny.swing.admin.statistics.chart;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.statistics.HistogramDataset;

import furny.ga.logger.StatisticsCache;
import furny.ga.logger.entities.EventType;
import furny.ga.logger.entities.IndividualEntry;

/**
 * The Class FitnessHistogramChart. The charts are just experimental and not
 * documented yet.
 * 
 * @since 12.08.2012
 * @author Stephan Dreyer
 */
public class FitnessHistogramChart implements IChartSettings {
  @Override
  public JFreeChart createChart(final long runId) {
    final List<IndividualEntry> list = StatisticsCache.getInstance()
        .getIndiduals(runId, EventType.POPULATION_INITIATED,
            EventType.INDIVIDUALS_INSERTED);

    final HistogramDataset dataset = new HistogramDataset();

    final Map<Integer, Integer> generationIndCount = new HashMap<Integer, Integer>();
    final Map<Integer, Double> generationFitness = new HashMap<Integer, Double>();

    for (final IndividualEntry entry : list) {
      final int generation = entry.getGeneration();

      Integer count = generationIndCount.get(generation);
      if (count != null) {
        count++;
      } else {
        count = 1;
      }
      generationIndCount.put(generation, count);

      Double fitness = generationFitness.get(generation);

      final Double newFitness = entry.getFitness();
      if (newFitness != null) {
        if (fitness != null) {
          fitness += newFitness;
        } else {
          fitness = newFitness;
        }
      }
      generationFitness.put(generation, fitness);

    }

    // THIS IS NOT REALLY WORKING

    for (final Entry<Integer, Integer> entry : generationIndCount.entrySet()) {
      final Double fitness;
      if (generationFitness.get(entry.getKey()) != null) {
        fitness = generationFitness.get(entry.getKey()).doubleValue()
            / entry.getValue().doubleValue();
      } else {
        fitness = null;
      }

      dataset.addSeries(entry.getKey(), new double[] { entry.getValue() }, 1);
    }

    final JFreeChart chart = ChartFactory.createHistogram(null, // Title
        "Generation", // X-Axis label
        "Fitness", // Y-Axis label
        dataset, // Dataset
        PlotOrientation.VERTICAL, //
        true, // Show legend
        true, // show tooltips
        false); // show urls

    return chart;
  }

  @Override
  public String toString() {
    return "Fitness histogram";
  }
}
